clc;
clear all;

rng(1)
n = 100;
samples = 50;
x = randn(n,samples);
closed_proj = zeros(n,samples);

tic
for i =1:samples
    y = project_simplex(x(:,i));
    closed_proj(:,i) = y;
end

fprintf('Time to project on closed form %.4e \n',toc)


opt_proj = zeros(n,samples);
tic
for i =1:samples
    v = x(:,i);
    options = optimoptions("quadprog",'Display','off');
    y = quadprog(eye(n),-v,[],[],ones(1,n),1,zeros(n,1),ones(n,1),[],options);
    opt_proj(:,i) = y;
end

fprintf('Time to project through optimization %.4e\n',toc)

% norm(closed_proj-opt_proj)
